<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\UserWs\Version1\UserApplicationAttribute\Show;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Error
 *
 * @Serializer\ExclusionPolicy("all")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\UserWs\Version1\UserApplicationAttribute\Show
 */
class Error
{
    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("code")
     *
     * @var string
     */
    private $code;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("message")
     *
     * @var string
     */
    private $message;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("type")
     *
     * @var string
     */
    private $type;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("exception")
     *
     * @var string
     */
    private $exception;

    /**
     * @Serializer\Expose
     * @Serializer\SerializedName("debug")
     *
     * @var string
     */
    private $debug;

    /**
     * @param string $code
     * @return Error
     */
    public function setCode($code)
    {
        $this->code = (int)$code;
        return $this;
    }

    /**
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param string $message
     * @return Error
     */
    public function setMessage($message)
    {
        $this->message = (string)$message;
        return $this;
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @param string $type
     * @return Error
     */
    public function setType($type)
    {
        $this->type = (string)$type;
        return $this;
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param string $debug
     * @return Error
     */
    public function setDebug($debug)
    {
        $this->debug = (string)$debug;
        return $this;
    }

    /**
     * @return string
     */
    public function getDebug()
    {
        return $this->debug;
    }

    /**
     * @param string $exception
     */
    public function setException($exception)
    {
        $this->exception = (string)$exception;
    }

    /**
     * @return string
     */
    public function getException()
    {
        return $this->exception;
    }
}
