<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\UserWs\Version1\UserService\PasswordConfirm;

use Sso\RestBundle\ModelRest\Response\Common\ResponseHead;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("userServicePasswordConfirm")
 * @Serializer\AccessorOrder("custom", custom = {"code", "status", "trackId", "date", "scriptTimeSec"})
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\UserWs\Version1\UserService\PasswordConfirm
 */
class Response
{
    use ResponseHead;

    /**
     * @Serializer\SerializedName("userPasswordConfirm")
     * @Serializer\Type("Sso\RestBundle\ModelRest\Response\UserWs\Version1\UserService\PasswordConfirm\UserPasswordConfirm")
     *
     * @var UserPasswordConfirm
     */
    private $userPasswordConfirm;

    /**
     * Response constructor.
     */
    public function __construct()
    {
        $this->userPasswordConfirm = new UserPasswordConfirm();
    }

    /**
     * @return UserPasswordConfirm
     */
    public function getUserPasswordConfirm()
    {
        return $this->userPasswordConfirm;
    }

    /**
     * @param UserPasswordConfirm $userPasswordConfirm
     * @return Response
     */
    public function setUserPasswordConfirm(UserPasswordConfirm $userPasswordConfirm)
    {
        $this->userPasswordConfirm = $userPasswordConfirm;

        return $this;
    }
}
