<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplicationAttribute\Show;

use Sso\RestBundle\ModelRest\Common\Response\UserWs\UserTypeFields;
use Sso\RestBundle\ModelRest\Response\Common\ResponseHead;
use Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserApplicationAttribute\Show\Success\ApplicationType as XmlApplicationType;
use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;
use Sso\RestBundle\ModelRest\Common\Response\UserWs\ErrorCollector\Error;

/**
 * Class UserType
 *
 * @Serializer\XmlRoot("userApplicationAttributes")
 * @Serializer\AccessorOrder("custom", custom={"code","status","guid","username","email","firstName","lastName","active","deleted","createdAt","updatedAt","lastLoginAt","authId","ldapSearchAttributes","ldapSearchValue","mfaEnabled"})
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplicationAttribute\Show
 */
class UserType
{
    use ResponseHead, UserTypeFields;

    /**
     * @Serializer\SerializedName("deleted")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    private $deleted;

    /**
     * @Serializer\SerializedName("createdAt")
     * @Serializer\Type("DateTime")
     *
     * @var \DateTime
     */
    private $createdAt;

    /**
     * @Serializer\SerializedName("updatedAt")
     * @Serializer\Type("DateTime")
     *
     * @var \DateTime
     */
    private $updatedAt;

    /**
     * @Serializer\SerializedName("lastLoginAt")
     * @Serializer\Type("DateTime")
     *
     * @var \DateTime
     */
    private $lastLoginAt;

    /**
     * @Serializer\SerializedName("mfaEnabled")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    private $mfaEnabled;

    /**
     * @Serializer\SerializedName("applicationType")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplicationAttribute\Show\ApplicationType>")
     * @Serializer\XmlList(inline=true,entry="applicationType")
     *
     * @var ApplicationType[]|ArrayCollection
     */
    private $applicationType;

    /**
     * @Serializer\SerializedName("errors")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Common\Response\UserWs\ErrorCollector\Error>")
     * @Serializer\XmlList(entry="error")
     *
     * @var Error[]|ArrayCollection
     */
    private $error;

    /**
     * @return int
     */
    public function getDeleted()
    {
        return $this->deleted;
    }

    /**
     * @param int $deleted
     * @return UserType
     */
    public function setDeleted($deleted)
    {
        $this->deleted = $deleted;

        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * @param \DateTime $createdAt
     * @return UserType
     */
    public function setCreatedAt($createdAt)
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * @param \DateTime $updatedAt
     * @return UserType
     */
    public function setUpdatedAt($updatedAt)
    {
        $this->updatedAt = $updatedAt;

        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getLastLoginAt()
    {
        return $this->lastLoginAt;
    }

    /**
     * @param \DateTime $lastLoginAt
     * @return UserType
     */
    public function setLastLoginAt($lastLoginAt)
    {
        $this->lastLoginAt = $lastLoginAt;

        return $this;
    }

    /**
     * @return int
     */
    public function getMfaEnabled()
    {
        return $this->mfaEnabled;
    }

    /**
     * @param int $mfaEnabled
     * @return UserType
     */
    public function setMfaEnabled($mfaEnabled)
    {
        $this->mfaEnabled = $mfaEnabled;

        return $this;
    }

    /**
     * @return ApplicationType[]|ArrayCollection
     */
    public function getApplicationType()
    {
        return $this->applicationType;
    }

    /**
     * @param XmlApplicationType $applicationType
     * @return UserType
     */
    public function setApplicationType(XmlApplicationType $applicationType = null)
    {
        if (!empty($applicationType)) {
            // Prevent an empty object in an error response
            if (!$this->applicationType) {
                $this->applicationType = new ArrayCollection();
            }

            // Fix for Sso\RestBundle\Api\Helper\Mapper
            $appType = new ApplicationType();
            $appType
                ->setName($applicationType->getName())
                ->setActive($applicationType->getActive());

            foreach ($applicationType->getAttributeType() as $attributeType) {
                $applicationAttribute = new ApplicationAttribute();
                $applicationAttribute
                    ->setName($attributeType->getName())
                    ->setType($attributeType->getType())
                    ->setValue($attributeType->getValue());

                $appType->setApplicationAttribute($applicationAttribute);
            }

            if (!$this->applicationType->contains($appType)) {
                $this->applicationType->add($appType);
            }
        }

        return $this;
    }

    /**
     * @return Error[]|ArrayCollection
     */
    public function getError()
    {
        return $this->error;
    }

    /**
     * @param Error $error
     * @return UserType
     */
    public function setError(Error $error)
    {
        // Prevent empty error array in success response
        if (!$this->error) {
            $this->error = new ArrayCollection();
        }

        if (!$this->error->contains($error)) {
            $this->error->add($error);
        }

        return $this;
    }
}
