<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplicationRole\Show;

use Sso\RestBundle\ModelRest\Response\Common\ResponseHead;
use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("userRoleShow")
 * @Serializer\AccessorOrder("custom", custom = {"code", "status", "trackId", "date", "scriptTimeSec", "userRoles"})
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplicationRole\Show
 */
class Response
{
    use ResponseHead;

    /**
     * @Serializer\SerializedName("userTypes")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserApplicationRole\Show\UserType>")
     * @Serializer\XmlList(entry="userType")
     *
     * @var ArrayCollection|UserType[]
     */
    protected $userType;

    /**
     * Response constructor.
     */
    public function __construct()
    {
        $this->userType = new ArrayCollection();
    }

    /**
     * @return ArrayCollection|UserType[]
     */
    public function getUserType()
    {
        return $this->userType;
    }

    /**
     * @param UserType $userType
     *
     * @return $this
     */
    public function addUserType(UserType $userType)
    {
        if (!$this->userType->contains($userType)) {
            $this->userType->add($userType);
        }

        return $this;
    }
}
