<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserSearch\Advanced;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;
use Sso\RestBundle\ModelShared\Response\UserWs\Version2\UserSearch\Advanced\Success\User;
use Sso\RestBundle\ModelRest\Response\Common\ResponseHead;
use Sso\RestBundle\ModelRest\Common\Response\UserWs\ErrorCollector\Error;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("userSearchAdvanced")
 *
 * @Serializer\AccessorOrder("custom", custom={"code","status","message","trackId","date","scriptTimeSec","count","offset","limit","orderBy","orderDir","fullResponse","users"})
 *
 * @package Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserSearch\Advanced;
 */
final class Response
{
    use ResponseHead;

    /**
     * @Serializer\SerializedName("count")
     * @Serializer\Type("integer")
     * @var integer
     */
    protected $count;

    /**
     * @Serializer\SerializedName("offset")
     * @Serializer\Type("integer")
     * @var integer
     */
    protected $offset;

    /**
     * @Serializer\SerializedName("limit")
     * @Serializer\Type("integer")
     * @var integer
     */
    protected $limit;

    /**
     * @Serializer\SerializedName("orderBy")
     * @Serializer\Type("string")
     * @var string
     */
    private $orderBy;

    /**
     * @Serializer\SerializedName("orderDir")
     * @Serializer\Type("string")
     * @var string
     */
    private $orderDir;

    /**
     * @Serializer\SerializedName("fullResponse")
     * @Serializer\Type("integer")
     * @var integer
     */
    protected $fullResponse;

    /**
     * @Serializer\SerializedName("users")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelShared\Response\UserWs\Version2\UserSearch\Advanced\Success\User>")
     * @Serializer\XmlList(inline = true, entry = "users")
     * @var User[]
     */
    private $users;

    /**
     * @Serializer\SerializedName("errors")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Common\Response\UserWs\ErrorCollector\Error>")
     * @Serializer\XmlList(entry="error")
     *
     * @var Error[]|ArrayCollection
     */
    private $error;

    /**
     * @param User $user
     * @return Response
     */
    public function addUser(User $user)
    {
        if (null === $this->users) {
            $this->users = new ArrayCollection();
        }

        $this->users->add($user);

        return $this;
    }

    /**
     * @return User[]
     */
    public function getUsers()
    {
        return $this->users;
    }

    public function setUser($users)
    {
        $this->users = $users;
    }

    /**
     * @return Error[]|ArrayCollection
     */
    public function getError()
    {
        return $this->error;
    }

    /**
     * @param Error $error
     * @return Response
     */
    public function setError(Error $error)
    {
        // Prevent empty error array in success response
        if (!$this->error) {
            $this->error = new ArrayCollection();
        }

        if (!$this->error->contains($error)) {
            $this->error->add($error);
        }

        return $this;
    }

    /**
     * @return integer
     */
    public function getCount()
    {
        return $this->count;
    }

    /**
     * @param integer $count
     * @return Response
     */
    public function setCount($count)
    {
        $this->count = $count;
        return $this;
    }

    /**
     * @return int
     */
    public function getOffset()
    {
        return $this->offset;
    }

    /**
     * @param int $offset
     * @return Response
     */
    public function setOffset($offset)
    {
        $this->offset = $offset;
        return $this;
    }

    /**
     * @return int
     */
    public function getLimit()
    {
        return $this->limit;
    }

    /**
     * @param int $limit
     * @return Response
     */
    public function setLimit($limit)
    {
        $this->limit = $limit;
        return $this;
    }

    /**
     * @return int
     */
    public function getFullResponse()
    {
        return $this->fullResponse;
    }

    /**
     * @param int $fullResponse
     * @return Response
     */
    public function setFullResponse($fullResponse)
    {
        $this->fullResponse = $fullResponse;
        return $this;
    }

    /**
     * @return string
     */
    public function getOrderBy()
    {
        return $this->orderBy;
    }

    /**
     * @param string $orderBy
     * @return Response
     */
    public function setOrderBy($orderBy)
    {
        $this->orderBy = $orderBy;
        return $this;
    }

    /**
     * @return string
     */
    public function getOrderDir()
    {
        return $this->orderDir;
    }

    /**
     * @param string $orderDir
     * @return Response
     */
    public function setOrderDir($orderDir)
    {
        $this->orderDir = $orderDir;
        return $this;
    }
}
