<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserSearch\FindByApplication;

use Sso\RestBundle\ModelXml\Response\UserWs\Version2\UserSearch\FindByApplication\Success\UserType as XmlUserType;
use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserByApplication
 *
 * @Serializer\XmlRoot("userSearchByApplication")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserSearch\FindByApplication
 */
class UserByApplication
{
    /**
     * @Serializer\SerializedName("userType")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserSearch\FindByApplication\UserType>")
     * @Serializer\XmlList(inline=true,entry="userType")
     *
     * @var UserType[]|ArrayCollection
     */
    private $userType;

    /**
     * @return UserType[]|ArrayCollection
     */
    public function getUserType()
    {
        return $this->userType;
    }

    /**
     * @param UserType[]|ArrayCollection $userTypes
     * @return UserByApplication
     */
    public function setUserType($userTypes)
    {
        // Prevent an empty object in an error response
        if (!$this->userType) {
            $this->userType = new ArrayCollection();
        }

        // Fix for Sso\RestBundle\Api\Helper\Mapper
        $uTypes = new ArrayCollection();
        if ($userTypes->count()) {
            foreach ($userTypes as $userType) {
                if ($userType instanceof XmlUserType) {
                    $uType = new UserType();
                    $uType
                        ->setGuid($userType->getGuid())
                        ->setEmail($userType->getEmail())
                        ->setUsername($userType->getUsername())
                        ->setActive($userType->getActive());

                    $uTypes->add($uType);
                } else {
                    $uTypes->add($userType);
                }
            }
        }

        $this->userType = $uTypes;

        return $this;
    }
}
