<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserSearch\FindByApplicationAttribute;

use Sso\RestBundle\ModelRest\Response\Common\ResponseHead;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("userSearchByAttribute")
 * @Serializer\AccessorOrder("custom", custom = {"code", "status", "trackId", "date", "scriptTimeSec"})
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserSearch\FindByApplicationAttribute
 */
class Response
{
    use ResponseHead;

    /**
     * @Serializer\SerializedName("userByAttribute")
     * @Serializer\Type("Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserSearch\FindByApplicationAttribute\UserByAttribute")
     *
     * @var UserByAttribute
     */
    private $userByAttribute;

    /**
     * Response constructor.
     */
    public function __construct()
    {
        $this->userByAttribute = new UserByAttribute();
    }

    /**
     * @return UserByAttribute
     */
    public function getUserByAttribute()
    {
        return $this->userByAttribute;
    }

    /**
     * @param UserByAttribute $userByAttribute
     * @return Response
     */
    public function setUserByAttribute(UserByAttribute $userByAttribute)
    {
        $this->userByAttribute = $userByAttribute;

        return $this;
    }
}
