<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserSearch\FindByApplicationRole;

use Sso\RestBundle\ModelRest\Response\Common\ResponseHead;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("userSearchByRole")
 * @Serializer\AccessorOrder("custom", custom = {"code", "status", "trackId", "date", "scriptTimeSec"})
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserSearch\FindByApplicationRole
 */
class Response
{
    use ResponseHead;

    /**
     * @Serializer\SerializedName("userByRole")
     * @Serializer\Type("Sso\RestBundle\ModelRest\Response\UserWs\Version2\UserSearch\FindByApplicationRole\UserByRole")
     *
     * @var UserByRole
     */
    private $userByRole;

    /**
     * Response constructor.
     */
    public function __construct()
    {
        $this->userByRole = new UserByRole();
    }

    /**
     * @return UserByRole
     */
    public function getUserByRole()
    {
        return $this->userByRole;
    }

    /**
     * @param UserByRole $userByRole
     * @return Response
     */
    public function setUserByRole(UserByRole $userByRole)
    {
        $this->userByRole = $userByRole;

        return $this;
    }
}
