<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelShared\Request\UserWs\Version2\UserSearch\Advanced;

use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Filter
 *
 * @Serializer\XmlRoot("Filter")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelShared\Request\UserWs\Version2\UserSearch\Advanced;
 */
final class Filter
{
    /**
     * @Assert\NotBlank()
     * @Assert\Regex(
     *     pattern="/(EQ|GT|GTE|LT|LTE|LIKE|REGEX)/",
     *     match=true,
     *     message="Strategy must be (EQ|GT|GTE|LT|LTE|LIKE|REGEX)"
     * )
     *
     * @Serializer\SerializedName("Strategy")
     * @Serializer\Type("string")
     * @var string
     */
    private $strategy;

    /**
     * @Assert\NotBlank()
     * @Assert\Regex(
     *     pattern="/(AND|OR)/",
     *     match=true,
     *     message="Operator must be (AND|OR)"
     * )
     * @Serializer\SerializedName("Operator")
     * @Serializer\Type("string")
     * @var string
     */
    private $operator;

    /**
     * @Assert\NotBlank()
     * @Assert\Regex(
     *     pattern="/(UserType|ApplicationType|Filters)/",
     *     match=true,
     *     message="FilterType must be (UserType|ApplicationType|Filters)"
     * )
     *
     * @Serializer\SerializedName("FilterType")
     * @Serializer\Type("string")
     * @var string
     */
    private $filterType;

    /**
     * @Assert\Valid
     * @Serializer\SerializedName("UserType")
     * @Serializer\Type("Sso\RestBundle\ModelShared\Request\UserWs\Version2\UserSearch\Advanced\UserType")
     * @var UserType
     */
    private $userType;

    /**
     * @Assert\Valid
     *
     * @Serializer\SerializedName("ApplicationType")
     * @Serializer\Type("Sso\RestBundle\ModelShared\Request\UserWs\Version2\UserSearch\Advanced\ApplicationType")
     * @var ApplicationType
     */
    private $applicationType;

    /**
     * @Assert\Valid
     *
     * @Serializer\SerializedName("Filters")
     * @Serializer\Type("Sso\RestBundle\ModelShared\Request\UserWs\Version2\UserSearch\Advanced\Filters")
     * @var Filters
     */
    private $filters;

    /**
     * @return string
     */
    public function getStrategy()
    {
        return $this->strategy;
    }

    /**
     * @param string $strategy
     * @return Filter
     */
    public function setStrategy($strategy)
    {
        $this->strategy = $strategy;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getOperator()
    {
        return $this->operator;
    }

    /**
     * @param mixed $operator
     * @return Filter
     */
    public function setOperator($operator)
    {
        $this->operator = $operator;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getFilterType()
    {
        return $this->filterType;
    }

    /**
     * @param mixed $filterType
     * @return Filter
     */
    public function setFilterType($filterType)
    {
        $this->filterType = $filterType;

        return $this;
    }

    /**
     * @return UserType
     */
    public function getUserType()
    {
        return $this->userType;
    }

    /**
     * @param mixed $userType
     * @return Filter
     */
    public function setUserType($userType)
    {
        $this->userType = $userType;

        return $this;
    }

    /**
     * @return ApplicationType
     */
    public function getApplicationType()
    {
        return $this->applicationType;
    }

    /**
     * @param ApplicationType $applicationType
     * @return Filter
     */
    public function setApplicationType($applicationType)
    {
        $this->applicationType = $applicationType;

        return $this;
    }

    /**
     * @return Filters
     */
    public function getFilters()
    {
        return $this->filters;
    }

    /**
     * @param Filters $filters
     * @return Filter
     */
    public function setFilters($filters)
    {
        $this->filters = $filters;

        return $this;
    }
}
