<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelShared\Response\UserWs\Version2\UserSearch\Advanced\Success;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class User
 * @package Sso\RestBundle\ModelShared\Response\UserWs\Version2\UserSearch\Advanced\Success
 */
final class User
{
    /**
     * @Serializer\SerializedName("UserType")
     * @Serializer\Type("Sso\RestBundle\ModelShared\Response\UserWs\Version2\UserSearch\Advanced\Success\UserType")
     * @var UserType
     */
    private $userType;

    /**
     * @Serializer\SerializedName("ApplicationType")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelShared\Response\UserWs\Version2\UserSearch\Advanced\Success\ApplicationType>")
     * @Serializer\XmlList(inline = true, entry = "ApplicationType")
     * @var ApplicationType[]
     */
    private $applicationType;


    public function __construct()
    {
        $this->applicationType = new ArrayCollection();
    }

    /**
     * @param string $status
     * @return User
     */
    public function setStatus($status)
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @param UserType $userType
     * @return User
     */
    public function setUserType(UserType $userType)
    {
        $this->userType = $userType;
        return $this;
    }

    /**
     * @param ApplicationType $applicationType
     * @return User
     */
    public function addApplicationType(ApplicationType $applicationType)
    {
        $this->applicationType->add($applicationType);

        return $this;
    }

    /**
     * @return UserType
     */
    public function getUserType()
    {
        return $this->userType;
    }

    /**
     * @return ApplicationType[]
     */
    public function getApplicationType()
    {
        return $this->applicationType;
    }
}
