<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Common\Request\Credentials\ObjectWs;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class ServiceProvider
 *
 * @Serializer\XmlRoot("ServiceProvider")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Common\Request\Credentials\ObjectWs
 */
class ServiceProvider
{

    /**
     * @Serializer\SerializedName("ServiceToken")
     * @Serializer\Type("string")
     * @var string
     */
    protected $serviceToken;

    /**
     * @Serializer\SerializedName("ServiceName")
     * @Serializer\Type("string")
     * @var string
     */
    protected $serviceName;

    /**
     *
     * @param string $serviceName
     */
    public function setServiceName($serviceName)
    {
        $this->serviceName = $serviceName;
    }

    /**
     *
     * @return string
     */
    public function getServiceToken()
    {
        return $this->serviceToken;
    }

    /**
     *
     * @param string $serviceToken
     */
    public function setServiceToken($serviceToken)
    {
        $this->serviceToken = $serviceToken;
    }

    /**
     *
     * @return string
     */
    public function getServiceName()
    {
        return $this->serviceName;
    }

}
