<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\IdpWs\ServiceUser;

/**
 * Class Factory
 * @package Sso\RestBundle\ModelXml\Request\IdpWs\ServiceUser
 */
class Factory
{
    /**
     * @param string $username
     * @param string $password
     * @return Get\Request
     */
    public function get($username, $password)
    {
        return new Get\Request($username, $password);
    }

    /**
     *
     * @param string $username
     * @param string $userIdentifier
     * @return Validate\Request
     */
    public function validate($username, $userIdentifier)
    {
        return new Validate\Request($username, $userIdentifier);
    }
}
