<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\IdpWs\ServiceUser\Validate;

use JMS\Serializer\Annotation as Serializer;
use Sso\Tools\UserIdentifierBundle\Model\Request\Node;

/**
 * Steps GetAction
 *
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class Validate
{
    /**
     * @Serializer\SerializedName("Key")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\IdpWs\ServiceUser\Validate\Key")
     * @var Node\Key
     */
    private $key;

    /**
     * Validate constructor.
     * @param string $username
     * @param string $userIdentifier
     */
    public function __construct($username, $userIdentifier)
    {
        $this->key = new Key($username, $userIdentifier);
    }
}