<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Attribute\Show;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Attribute
 *
 * @Serializer\XmlRoot("Credentials")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Attribute\Show
 */
class Attribute
{
    /**
     * @Serializer\SerializedName("Show")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Attribute\Show\Show")
     *
     * @var Show
     */
    private $show;

    /**
     * @param Show $show
     */
    public function setShow(Show $show)
    {
        $this->show = $show;
    }

    /**
     * @return Show
     */
    public function getShow()
    {
        return $this->show;
    }

    /**
     * @param string $id
     * @param int $offset
     * @param int $limit
     */
    public function setAttributeTypeData($id, $offset, $limit)
    {
        $attributeType = new AttributeType();
        if ($id != null) {
            $attributeType->setId($id);
        }
        if ($offset != null) {
            $attributeType->setOffset($offset);
        }
        if ($limit != null) {
            $attributeType->setLimit($limit);
        }

        $show = new Show();
        $show->setAttributeType($attributeType);
        $this->setShow($show);
    }
}
