<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Attribute\Update;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 *
 * @Serializer\XmlRoot("Attribute")
 *
 * Class ApplicationAttribute
 * @package Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Attribute\Update
 */
class Attribute
{
    /**
     * @Serializer\SerializedName("Update")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Attribute\Update\Update")
     *
     * @var Update
     */
    private $update;

    /**
     * @param string $attrId
     * @param string $attrName
     * @param int $attrMandatory
     * @param array|ArrayCollection $attrPossibleValues
     * @param string $attrDefaultValue
     * @param int $attrTranslatable
     * @param string $attrGroupId
     */
    public function setAttribute(
        $attrId,
        $attrName,
        $attrMandatory,
        $attrPossibleValues,
        $attrDefaultValue,
        $attrTranslatable,
        $attrGroupId
    ) {
        $attributeType = new AttributeType();
        $attributeType
            ->setId($attrId)
            ->setName($attrName)
            ->setMandatory($attrMandatory)
            ->setDefaultValue($attrDefaultValue)
            ->setTranslatable($attrTranslatable)
            ->setGroupId($attrGroupId);

        if (!empty($attrPossibleValues)) {
            foreach ($attrPossibleValues as $possibleValue) {
                $attributeType->setPossibleValues($possibleValue);
            }
        }

        $update = new Update();
        $update->setAttributeType($attributeType);

        $this->setUpdate($update);
    }

    /**
     * @return Update
     */
    public function getUpdate()
    {
        return $this->update;
    }

    /**
     * @param Update $update
     * @return Attribute
     */
    public function setUpdate(Update $update)
    {
        $this->update = $update;

        return $this;
    }
}
