<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Attribute\Update;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 *
 * @Serializer\XmlRoot("Update")
 *
 * Class AttributeType
 * @package Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Attribute\Update
 */
class AttributeType
{
    /**
     * @Serializer\SerializedName("Id")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $id;

    /**
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("Mandatory")
     * @Serializer\Type("integer")
     *
     * @var int
     */
    private $mandatory;

    /**
     * @Serializer\SerializedName("PossibleValues")
     * @Serializer\Type("ArrayCollection<string>")
     * @Serializer\XmlList(entry="Value")
     *
     * @var ArrayCollection|string[]
     */
    private $possibleValues;

    /**
     * @Serializer\SerializedName("DefaultValue")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $defaultValue;

    /**
     * @Serializer\SerializedName("Translatable")
     * @Serializer\Type("integer")
     *
     * @var int
     */
    private $translatable;

    /**
     * @Serializer\SerializedName("GroupId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $groupId;

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param string $id
     * @return AttributeType
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return int
     */
    public function getMandatory()
    {
        return $this->mandatory;
    }

    /**
     * @param int $mandatory
     * @return AttributeType
     */
    public function setMandatory($mandatory)
    {
        $this->mandatory = $mandatory;
        return $this;
    }

    /**
     * @return ArrayCollection|string[]
     */
    public function getPossibleValues()
    {
        return $this->possibleValues;
    }

    /**
     * @param ArrayCollection|string[] $possibleValues
     * @return AttributeType
     */
    public function setPossibleValues($possibleValues)
    {
        if (!$this->possibleValues) {
            $this->possibleValues = new ArrayCollection();
        }

        if (!$this->possibleValues->contains($possibleValues)) {
            $this->possibleValues->add($possibleValues);
        }

        return $this;
    }

    /**
     * @return string
     */
    public function getDefaultValue()
    {
        return $this->defaultValue;
    }

    /**
     * @param string $defaultValue
     * @return AttributeType
     */
    public function setDefaultValue($defaultValue)
    {
        $this->defaultValue = $defaultValue;
        return $this;
    }

    /**
     * @return int
     */
    public function getTranslatable()
    {
        return $this->translatable;
    }

    /**
     * @param int $translatable
     * @return AttributeType
     */
    public function setTranslatable($translatable)
    {
        $this->translatable = $translatable;
        return $this;
    }

    /**
     * @param string $name
     * @return AttributeType
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return string
     */
    public function getGroupId()
    {
        return $this->groupId;
    }

    /**
     * @param string $groupId
     * @return AttributeType
     */
    public function setGroupId($groupId)
    {
        $this->groupId = $groupId;

        return $this;
    }
}
