<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\AttributeGroup\Show;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class AttributeGroup
 *
 * @Serializer\XmlRoot("Credentials")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\AttributeGroup\Show
 */
class AttributeGroup
{

    /**
     * @Serializer\SerializedName("Show")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\AttributeGroup\Show\Show")
     * @var Show
     */
    protected $show;

    /**
     *
     * @param Show $show
     */
    public function setShow(Show $show)
    {
        $this->show = $show;
    }

    /**
     *
     * @return Show
     */
    public function getShow()
    {
        return $this->show;
    }

    /**
     *
     * @param string $id
     * @param int $offset
     * @param int $limit
     */
    public function setAttributeGroupTypeData($id, $offset, $limit)
    {
        $attributeGroupType = new AttributeGroupType();
        if ($id != null) {
            $attributeGroupType->setId($id);
        }
        if ($offset != null) {
            $attributeGroupType->setOffset($offset);
        }
        if ($limit != null) {
            $attributeGroupType->setLimit($limit);
        }

        $show = new Show();
        $show->setAttributeGroupType($attributeGroupType);
        $this->setShow($show);
    }

}
