<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\AttributeGroup\Update;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class AttributeGroupType
 *
 * @Serializer\XmlRoot("AttributeGroupType")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\AttributeGroup\Update
 */
class AttributeGroupType
{
    /**
     * @Serializer\SerializedName("Id")
     * @Serializer\Type("string")
     * @var string
     */
    private $id;

    /**
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("AddTypes")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\AttributeGroup\Update\AddType")
     *
     * @var AddType
     */
    private $addType;

    /**
     * @Serializer\SerializedName("DeleteTypes")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\AttributeGroup\Update\DeleteType")
     *
     * @var DeleteType
     */
    private $deleteType;

    /**
     * @Serializer\SerializedName("DeleteReferences")
     * @Serializer\Type("boolean")
     *
     * @var boolean
     */
    private $deleteReferences;

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param string $id
     *
     * @return AttributeGroupType
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     *
     * @return $this
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return AddType
     */
    public function getAddType()
    {
        return $this->addType;
    }

    /**
     * @param AddType $addType
     *
     * @return AttributeGroupType
     */
    public function setAddType(AddType $addType)
    {
        $this->addType = $addType;

        return $this;
    }

    /**
     * @return DeleteType
     */
    public function getDeleteType()
    {
        return $this->deleteType;
    }

    /**
     * @param DeleteType $deleteType
     *
     * @return AttributeGroupType
     */
    public function setDeleteType(DeleteType $deleteType)
    {
        $this->deleteType = $deleteType;

        return $this;
    }

    /**
     * @return boolean
     */
    public function isDeleteReferences()
    {
        return $this->deleteReferences;
    }

    /**
     * @param boolean $deleteReferences
     * @return AttributeGroupType
     */
    public function setDeleteReferences($deleteReferences)
    {
        $this->deleteReferences = $deleteReferences;

        return $this;
    }
}
