<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Add;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Object
 *
 * @Serializer\XmlRoot("SsoRequest")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Add
 */
class Object
{
    /**
     * @Serializer\SerializedName("Add")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Add\Add")
     *
     * @var Add
     */
    private $add;

    /**
     * @param Add $add
     */
    public function setAdd(Add $add)
    {
        $this->add = $add;
    }

    /**
     * @return Add
     */
    public function getAdd()
    {
        return $this->add;
    }

    /**
     * @param string $referenceId
     * @param string $typeId
     * @param string $parentGuid
     * @param string $name
     * @param int $active
     */
    public function setObjectData($referenceId, $typeId, $parentGuid, $name, $active)
    {
        $objectType = new ObjectType();
        $objectType->setReferenceId($referenceId);
        $objectType->setTypeId($typeId);
        $objectType->setParentGuid($parentGuid);
        $objectType->setName($name);
        $objectType->setActive($active);

        $add = new Add();
        $add->setObjectType($objectType);
        $this->setAdd($add);
    }
}
