<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Delete;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Delete
 *
 * @Serializer\XmlRoot("Delete")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Delete
 */
class Delete
{

    /**
     * @Serializer\SerializedName("ObjectType")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Delete\ObjectType")
     * @var ObjectType
     */
    protected $objectType;

    /**
     *
     * @param ObjectType $objectType
     */
    public function setObjectType(ObjectType $objectType)
    {
        $this->objectType = $objectType;
    }

    /**
     *
     * @return ObjectType
     */
    public function getObjectType()
    {
        return $this->objectType;
    }

}
