<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Show\Multi;

use Sso\RestBundle\ModelXml\Common\Request\Credentials\ObjectWs;
use Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Show\Multi\Object as RequestObject;

/**
 * XML request model for object get factory
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Show\Multi
 */
class Factory
{

    /**
     * @var array
     */
    protected $facSetter;

    /**
     * @return Request
     */
    public function request()
    {
        if (!isset($this->facSetter['request'])) {
            $this->facSetter['request'] = new Request();
        }
        return $this->facSetter['request'];
    }

    /**
     * @return ObjectWs\Credentials
     */
    public function credentials()
    {
        if (!isset($this->facSetter['credentials'])) {
            $this->facSetter['credentials'] = new ObjectWs\Credentials();
        }
        return $this->facSetter['credentials'];
    }

    /**
     * @return RequestObject
     */
    public function object()
    {
        if (!isset($this->facSetter['object'])) {
            $this->facSetter['object'] = new Object();
        }
        return $this->facSetter['object'];
    }

}
