<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Update;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Object
 *
 * @Serializer\XmlRoot("SsoRequest")
 * @package Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Update
 */
class Object
{
    /**
     * @Serializer\SerializedName("Update")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Update\Update")
     *
     * @var Update
     */
    private $update;

    /**
     *
     * @param Update $update
     */
    public function setUpdate(Update $update)
    {
        $this->update = $update;
    }

    /**
     *
     * @return Update
     */
    public function getUpdate()
    {
        return $this->update;
    }

    /**
     *
     * @param string $guid
     * @param string $referenceId
     * @param string $typeId
     * @param string $parentGuid
     * @param string $name
     * @param int $active
     */
    public function setObjectData($guid, $referenceId, $typeId, $parentGuid, $name, $active)
    {
        $objectType = new ObjectType();
        $objectType
            ->setGuid($guid)
            ->setReferenceId($referenceId)
            ->setTypeId($typeId)
            ->setParentGuid($parentGuid)
            ->setName($name)
            ->setActive($active);

        $update = new Update();
        $update->setObjectType($objectType);
        $this->setUpdate($update);
    }
}
