<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Update;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class ObjectType
 *
 * @Serializer\XmlRoot("Update")
 *
 * @package Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\Object\Update
 */
class ObjectType
{
    /**
     * @Serializer\SerializedName("Guid")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $guid;

    /**
     * @Serializer\SerializedName("ReferenceId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $referenceId;

    /**
     * @Serializer\SerializedName("TypeId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $typeId;

    /**
     * @Serializer\SerializedName("ParentGuid")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $parentGuid;

    /**
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("Active")
     * @Serializer\Type("integer")
     *
     * @var int
     */
    private $active;

    /**
     * @return string
     */
    public function getGuid()
    {
        return $this->guid;
    }

    /**
     * @param string $guid
     * @return ObjectType
     */
    public function setGuid($guid)
    {
        $this->guid = $guid;
        return $this;
    }

    /**
     * @return string
     */
    public function getReferenceId()
    {
        return $this->referenceId;
    }

    /**
     * @param string $referenceId
     * @return ObjectType
     */
    public function setReferenceId($referenceId)
    {
        $this->referenceId = $referenceId;
        return $this;
    }

    /**
     * @return string
     */
    public function getTypeId()
    {
        return $this->typeId;
    }

    /**
     * @param string $typeId
     * @return ObjectType
     */
    public function setTypeId($typeId)
    {
        $this->typeId = $typeId;
        return $this;
    }

    /**
     * @return string
     */
    public function getParentGuid()
    {
        return $this->parentGuid;
    }

    /**
     * @param string $parentGuid
     * @return ObjectType
     */
    public function setParentGuid($parentGuid)
    {
        $this->parentGuid = $parentGuid;
        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return ObjectType
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return int
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * @param int $active
     * @return ObjectType
     */
    public function setActive($active)
    {
        $this->active = $active;
        return $this;
    }
}
