<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectType\Add\ObjectTypeAdd;

use JMS\Serializer\Annotation as Serializer;

/**
 * @Serializer\XmlRoot("Credentials")
 */
class ObjectType
{
    /**
     * @Serializer\SerializedName("Add")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectType\Add\ObjectTypeAdd\Add")
     * @var Add
     */
    protected $add;

    /**
     * @param Add $add
     */
    public function setAdd(Add $add)
    {
        $this->add = $add;
    }

    /**
     * @return Add
     */
    public function getAdd()
    {
        return $this->add;
    }

    /**
     * @param string $name
     * @param string $order
     */
    public function setObjectTypeData($name, $order)
    {
        $objectType = new TypeType();
        $objectType->setName($name);
        $objectType->setOrder($order);

        $add = new Add();
        $add->setObjectType($objectType);
        $this->setAdd($add);
    }
}
