<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectType\Show;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Type
 *
 * @Serializer\XmlRoot("Type")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectType\Show
 */
class Type
{
    /**
     * @Serializer\SerializedName("Show")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectType\Show\Show")
     * @var Show
     */
    protected $show;

    /**
     * @param Show $show
     */
    public function setShow(Show $show)
    {
        $this->show = $show;
    }

    /**
     * @return Show
     */
    public function getShow()
    {
        return $this->show;
    }

    /**
     * @param string $id
     * @param string $name
     */
    public function setTypeTypeData($id, $name)
    {
        $typeType = new TypeType();
        if ($id != null) {
            $typeType->setId($id);
        }
        if ($name != null) {
            $typeType->setName($name);
        }

        $show = new Show();
        $show->setTypeType($typeType);
        $this->setShow($show);
    }
}
