<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectValue\Add\ObjectValueAdd;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class ObjectValue
 *
 * @Serializer\XmlRoot("Credentials")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectValue\Add\ObjectValueAdd
 */
class ObjectValue
{
    /**
     * @Serializer\SerializedName("Add")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectValue\Add\ObjectValueAdd\Add")
     * @var Add
     */
    protected $add;

    /**
     * @param Add $add
     */
    public function setAdd(Add $add)
    {
        $this->add = $add;
    }

    /**
     * @return Add
     */
    public function getAdd()
    {
        return $this->add;
    }

    /**
     * @param string $objectGuid
     * @param string $objectValue
     * @param string $languageCode
     * @param string $attributeId
     */
    public function setObjectValueData($objectGuid, $objectValue, $languageCode, $attributeId)
    {
        $objectValueType = new ObjectValueType();
        $objectValueType
            ->setObjectGuid($objectGuid)
            ->setObjectValue($objectValue)
            ->setLanguageCode($languageCode)
            ->setAttributeId($attributeId);

        $add = new Add();
        $add->setObjectValueType($objectValueType);
        $this->setAdd($add);
    }
}
