<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectValue\Delete;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class ObjectValue
 *
 * @Serializer\XmlRoot("Credentials")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectValue\Delete
 */
class ObjectValue
{
    /**
     * @Serializer\SerializedName("Delete")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectValue\Delete\Delete")
     * @var Delete
     */
    protected $delete;

    /**
     * @return Delete
     */
    public function getDelete()
    {
        return $this->delete;
    }

    /**
     * @param Delete $delete
     * @return ObjectValue
     */
    public function setDelete(Delete $delete)
    {
        $this->delete = $delete;
        return $this;
    }

    /**
     * @param string $attrGroupId
     */
    public function setObjectValueTypeData($attrGroupId)
    {
        $objectValueType = new ObjectValueType();
        $objectValueType->setId($attrGroupId);

        $delete = new Delete();
        $delete->setObjectValueType($objectValueType);
        $this->setDelete($delete);
    }
}
