<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectValue\Show;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Show
 *
 * @Serializer\XmlRoot("Show")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectValue\Show
 */
class Show
{
    /**
     * @Serializer\SerializedName("ObjectValueType")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectValue\Show\ObjectValueType")
     * @var ObjectValueType
     */
    protected $objectValueType;

    /**
     * @return ObjectValueType
     */
    public function getObjectValueType()
    {
        return $this->objectValueType;
    }

    /**
     * @param ObjectValueType $objectValueType
     * @return Show
     */
    public function setObjectValueType($objectValueType)
    {
        $this->objectValueType = $objectValueType;
        return $this;
    }
}
