<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectValue\Update;

use Sso\RestBundle\ModelXml\Common\Request\Credentials\ObjectWs\Credentials;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Request
 *
 * @Serializer\XmlRoot("SsoRequest")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectValue\Update\ObjectValueUpdate
 */
class Request
{
    /**
     * @Serializer\SerializedName("Credentials")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Common\Request\Credentials\ObjectWs\Credentials")
     * @var Credentials
     */
    private $credentials;

    /**
     * @Serializer\SerializedName("ObjectValue")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\ObjectWs\Version1\ObjectValue\Update\ObjectValue")
     * @var ObjectValue
     */
    private $objectValue;

    /**
     * @param Credentials $credentials
     */
    public function setCredentials(Credentials $credentials)
    {
        $this->credentials = $credentials;
    }

    /**
     * @return Credentials
     */
    public function getCredentials()
    {
        return $this->credentials;
    }

    /**
     * @param ObjectValue $objectValue
     */
    public function setObjectValue(ObjectValue $objectValue)
    {
        $this->objectValue = $objectValue;
    }

    /**
     * @return ObjectValue
     */
    public function getObjectValue()
    {
        return $this->objectValue;
    }
}
