<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\Application\Show;

use JMS\Serializer\Annotation as Serializer;
use Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs\Credentials;

/**
 * Class Request
 *
 * @Serializer\XmlRoot("SsoRequest")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\UserWs\Version1\Application\Show
 */
class Request
{
    /**
     * @Serializer\SerializedName("Credentials")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs\Credentials")
     * @var Credentials
     */
    protected $credentials;

    /**
     * @Serializer\SerializedName("Application")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version1\Application\Show\Application")
     * @var Application
     */
    protected $application;

    /**
     * @param Credentials $credentials
     */
    public function setCredentials(Credentials $credentials)
    {
        $this->credentials = $credentials;
    }

    /**
     * @return Credentials
     */
    public function getCredentials()
    {
        return $this->credentials;
    }

    /**
     * @param Application $application
     */
    public function setApplication(Application $application)
    {
        $this->application = $application;
    }

    /**
     * @return Application
     */
    public function getApplication()
    {
        return $this->application;
    }
}
