<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\ApplicationRole\Add;

use JMS\Serializer\Annotation as Serializer;

/**
 *
 * @Serializer\XmlRoot("ApplicationRole")
 *
 * Class ApplicationAttribute
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version1\ApplicationRole\Add
 */
class ApplicationRole
{
    /**
     * @Serializer\SerializedName("Add")
     * @Serializer\Type(" Sso\RestBundle\ModelXml\Request\UserWs\Version1\ApplicationRole\Add\Add")
     *
     * @var Add
     */
    private $add;

    /**
     * @param string $applicationName
     * @param string $name
     * @param string $description
     */
    public function setApplicationRole(
        $applicationName,
        $name,
        $description
    ) {
        $applicationType = new ApplicationType();
        $applicationType->setName($applicationName);

        $roleType = new RoleType();
        $roleType->setName($name)->setDescription($description);

        $key = new Key();
        $value = new Value();
        $add = new Add();

        $key->setApplicationType($applicationType);
        $add->setKey($key);

        $value->setRoleType($roleType);
        $add->setValue($value);

        $this->setAdd($add);
    }

    /**
     * @return Add
     */
    public function getAdd()
    {
        return $this->add;
    }

    /**
     * @param Add $add
     * @return ApplicationRole
     */
    public function setAdd(Add $add)
    {
        $this->add = $add;

        return $this;
    }
}
