<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\ApplicationRole\Show;

use JMS\Serializer\Annotation as Serializer;

/**
 *
 * @Serializer\XmlRoot("ApplicationRole")
 *
 * Class ApplicationAttribute
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version1\ApplicationRole\Show
 */
class ApplicationRole
{
    /**
     * @Serializer\SerializedName("Show")
     * @Serializer\Type(" Sso\RestBundle\ModelXml\Request\UserWs\Version1\ApplicationRole\Show\Show")
     *
     * @var Show
     */
    private $show;

    /**
     * @param string $applicationName
     * @param string $name
     */
    public function setApplicationRole(
        $applicationName,
        $name
    ) {
        $applicationType = new ApplicationType();
        $applicationType->setName($applicationName);

        $roleType = new RoleType();
        $roleType->setName($name);

        $key = new Key();
        $show = new Show();

        $key->setApplicationType($applicationType);
        $key->setRoleType($roleType);
        $show->setKey($key);

        $this->setShow($show);
    }

    /**
     * @return Show
     */
    public function getShow()
    {
        return $this->show;
    }

    /**
     * @param Show $show
     * @return ApplicationRole
     */
    public function setShow(Show $show)
    {
        $this->show = $show;

        return $this;
    }
}
