<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1;

/**
 * Class Factory
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Response
 */
class Factory
{
    /**
     * @var array
     */
    protected $facSetter;

    /**
     * @return Application\Factory
     */
    public function application()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Application\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return ApplicationAttribute\Factory
     */
    public function applicationAttribute()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new ApplicationAttribute\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return ApplicationRole\Factory
     */
    public function applicationRole()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new ApplicationRole\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return Attribute\Factory
     */
    public function attribute()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Attribute\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return User\Factory
     */
    public function user()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new User\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return UserApplication\Factory
     */
    public function userApplication()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new UserApplication\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return UserApplicationAttribute\Factory
     */
    public function userApplicationAttribute()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new UserApplicationAttribute\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return UserApplicationRole\Factory
     */
    public function userApplicationRole()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new UserApplicationRole\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return UserService\Factory
     */
    public function userService()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new UserService\Factory();
        }
        return $this->facSetter[__FUNCTION__];
    }
}
