<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\User\Delete;

use Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs;

/**
 * Class Factory
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version1\User\Delete
 */
class Factory
{
    /**
     *
     * @var array
     */
    protected $facSetter;

    /**
     *
     * @return Request
     */
    public function request()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Request();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     *
     * @return UserWs\Credentials
     */
    public function credentials()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new UserWs\Credentials();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     *
     * @return Delete
     */
    public function delete()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Delete();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return User
     */
    public function user()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new User();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return UserType
     */
    public function userType()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new UserType();
        }
        return $this->facSetter[__FUNCTION__];
    }
}