<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\User\Delete;

use JMS\Serializer\Annotation as Serializer;

/**
 * @Serializer\XmlRoot("User")
 *
 * Class User
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version1\User\Delete
 */
class User
{
    /**
     * @Serializer\SerializedName("Delete")
     * @Serializer\Type(" Sso\RestBundle\ModelXml\Request\UserWs\Version1\User\Delete\Delete")
     *
     * @var Delete
     */
    protected $delete;

    /**
     * @return Delete
     */
    public function getDelete()
    {
        return $this->delete;
    }

    /**
     * @param Delete $delete
     *
     * @return User
     */
    public function setDelete(Delete $delete)
    {
        $this->delete = $delete;

        return $this;
    }

    /**
     * @param string $userIdentifier
     */
    public function setUserTypeData($userIdentifier)
    {
        $delete = new Delete();
        $key = new Key();
        $userType = new UserType();

        $userType->setIdentifier($userIdentifier);
        $key->setUserType($userType);
        $delete->setKey($key);
        $this->setDelete($delete);
    }
}
