<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplication\Add;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserApplication
 *
 * @Serializer\XmlRoot("UserApplication")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplication\Add
 */
class UserApplication
{
    /**
     * @Serializer\SerializedName("Add")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplication\Add\Add")
     * @var Add
     */
    protected $add;

    /**
     * @param string $identifier
     * @param string $name
     * @param integer $active
     */
    public function setUserApplication(
        $identifier,
        $name,
        $active
    ) {
        // Set UserType
        $userType = new UserType();
        $userType->setIdentifier($identifier);

        // Set ApplicationType
        $applicationType = new ApplicationType();
        $applicationType->setName($name)->setActive($active);

        $key = new Key();
        $value = new Value();
        $add = new Add();

        $value->setApplicationType($applicationType);
        $add->setValue($value);

        $key->setUserType($userType);
        $add->setKey($key);

        $this->setAdd($add);
    }

    /**
     * @return Add
     */
    public function getAdd()
    {
        return $this->add;
    }

    /**
     * @param Add $add
     * @return UserApplication
     */
    public function setAdd(Add $add)
    {
        $this->add = $add;

        return $this;
    }
}
