<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplication\Add;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Value
 *
 * @Serializer\XmlRoot("Add")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplication\Add
 */
class Value
{
    /**
     * @Serializer\SerializedName("ApplicationType")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplication\Add\ApplicationType")
     * @var ApplicationType
     */
    protected $applicationType;

    /**
     * @return ApplicationType
     */
    public function getApplicationType()
    {
        return $this->applicationType;
    }

    /**
     * @param ApplicationType $applicationType
     * @return Value
     */
    public function setApplicationType(ApplicationType $applicationType)
    {
        $this->applicationType = $applicationType;

        return $this;
    }
}
