<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplicationAttribute\Add;

use JMS\Serializer\Annotation as Serializer;

/**
 *
 * @Serializer\XmlRoot("Value")
 *
 * Class Value
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplicationAttribute\Add
 */
class Value
{
    /**
     * @Serializer\SerializedName("AttributeType")
     * @Serializer\Type("array<Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplicationAttribute\Add\AttributeType>")
     * @Serializer\XmlList(inline=true, entry="AttributeType")
     *
     * @var AttributeType[]
     */
    private $attributeTypes = [];

    /**
     * @return AttributeType[]
     */
    public function getAttributeTypes()
    {
        return $this->attributeTypes;
    }

    /**
     * @param AttributeType $attributeType
     * @return Value
     */
    public function addAttributeType(AttributeType $attributeType)
    {
        $this->attributeTypes[] = $attributeType;

        return $this;
    }
}
