<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplicationAttribute\Show;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserApplicationAttribute
 *
 * @Serializer\XmlRoot("UserApplicationAttribute")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplicationAttribute\Show
 */
class UserApplicationAttribute
{
    /**
     * @Serializer\SerializedName("Show")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplicationAttribute\Show\Show")
     * @var Show
     */
    protected $show;

    /**
     * @param string $identifier
     * @param string $applicationName
     */
    public function __construct($identifier, $applicationName)
    {
        $showModel = new Show();
        $keyModel = new Key();

        $userTypeModel = new UserType();
        $userTypeModel->setIdentifier($identifier);
        $keyModel->setUserType($userTypeModel);

        $applicationTypeModel = new ApplicationType();
        $applicationTypeModel->setName($applicationName);
        $keyModel->setApplicationType($applicationTypeModel);

        $showModel->setKey($keyModel);
        $this->setShow($showModel);
    }

    /**
     * @return Show
     */
    public function getShow()
    {
        return $this->show;
    }

    /**
     * @param Show $show
     * @return UserApplicationAttribute
     */
    public function setShow($show)
    {
        $this->show = $show;

        return $this;
    }
}
