<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplicationRole\Add;

use Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs;

/**
 * Class Factory
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplicationRole\Add
 */
class Factory
{
    /**
     * @var array
     */
    protected $facSetter;

    /**
     *
     * @return Request
     */
    public function request()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Request();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     *
     * @return UserWs\Credentials
     */
    public function credentials()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new UserWs\Credentials();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     *
     * @return Add
     */
    public function add()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Add();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return UserApplicationRole
     */
    public function userApplicationRole()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new UserApplicationRole();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return Key
     */
    public function key()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Key();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return Value
     */
    public function value()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Value();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return RoleType
     */
    public function roleType()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new RoleType();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return UserType
     */
    public function userType()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new UserType();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return ApplicationType
     */
    public function applicationType()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new ApplicationType();
        }
        return $this->facSetter[__FUNCTION__];
    }
}