<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplicationRole\Add;

use JMS\Serializer\Annotation as Serializer;

/**
 *
 * @Serializer\XmlRoot("UserApplicationRole")
 *
 * Class UserApplication
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplicationRole\Add
 */
class UserApplicationRole
{
    /**
     * @Serializer\SerializedName("Add")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserApplicationRole\Add\Add")
     *
     * @var Add
     */
    protected $add;

    /**
     * @param string $identifier
     * @param string $applicationName
     * @param string $roleName
     * @param boolean $roleActive
     */
    public function setUserApplicationRoleTypeData($identifier, $applicationName, $roleName, $roleActive)
    {
        $userType = new UserType();
        $userType->setIdentifier($identifier);

        $applicationType = new ApplicationType();
        $applicationType->setName($applicationName);

        $roleType = new RoleType();
        $roleType->setName($roleName)
            ->setActive($roleActive);

        $key = new Key();
        $value = new Value();
        $add = new Add();

        $key->setUserType($userType);
        $key->setApplicationType($applicationType);
        $value->setRoleType($roleType);
        $add->setKey($key)
            ->setValue($value);

        $this->setAdd($add);
    }

    /**
     * @return Add
     */
    public function getAdd()
    {
        return $this->add;
    }

    /**
     * @param Add $add
     *
     * @return $this
     */
    public function setAdd(Add $add)
    {
        $this->add = $add;

        return $this;
    }
}
