<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserService\ActivateConfirm;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserApplication
 *
 * @Serializer\XmlRoot("UserService")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserService\ActivateConfirm
 */
class UserService
{
    /**
     * @Serializer\SerializedName("ActivateConfirm")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserService\ActivateConfirm\ActivateConfirm")
     * @var ActivateConfirm
     */
    protected $activateConfirm;

    /**
     * @param string $email
     * @param $activateToken
     */
    public function setUserServiceData($email, $activateToken)
    {
        // Set UserType
        $userType = new UserType();
        $userType
            ->setEmail($email)
            ->setActivateToken($activateToken);

        $key = new Key();
        $activateConfirm = new ActivateConfirm();

        $key->setUserType($userType);
        $activateConfirm->setKey($key);

        $this->setActivateConfirm($activateConfirm);
    }

    /**
     * @return ActivateConfirm
     */
    public function getActivateConfirm()
    {
        return $this->activateConfirm;
    }

    /**
     * @param ActivateConfirm $activateConfirm
     *
     * @return UserService
     */
    public function setActivateConfirm(ActivateConfirm $activateConfirm)
    {
        $this->activateConfirm = $activateConfirm;

        return $this;
    }
}
