<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserService\ActivateConfirm;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserType
 *
 * @Serializer\XmlRoot("UserType")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserService\ActivateConfirm
 */
class UserType
{
    /**
     * @Serializer\SerializedName("Email")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $email;

    /**
     * @Serializer\SerializedName("ActivateToken")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $activateToken;

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     *
     * @return UserType
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * @return string
     */
    public function getActivateToken()
    {
        return $this->activateToken;
    }

    /**
     * @param string $activateToken
     *
     * @return $this
     */
    public function setActivateToken($activateToken)
    {
        $this->activateToken = $activateToken;

        return $this;
    }
}
