<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserService\ActivateRequest;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Add
 *
 * @Serializer\XmlRoot("ActivateRequest")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserService\ActivateRequest
 */
class ActivateRequest
{
    /**
     * @Serializer\SerializedName("Key")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserService\ActivateRequest\Key")
     * @var Key
     */
    protected $key;

    /**
     * @return Key
     */
    public function getKey()
    {
        return $this->key;
    }

    /**
     * @param Key $key
     * @return ActivateRequest
     */
    public function setKey(Key $key)
    {
        $this->key = $key;

        return $this;
    }
}
