<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserService\ActivateRequest;

use Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs\Credentials;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Request
 *
 * @Serializer\XmlRoot("SsoRequest")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserService\ActivateRequest
 */
class Request
{
    /**
     * @Serializer\SerializedName("Credentials")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs\Credentials")
     * @var Credentials
     */
    protected $credentials;

    /**
     * @Serializer\SerializedName("UserService")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version1\UserService\ActivateRequest\UserService")
     * @var UserService
     */
    protected $userService;

    /**
     * @param Credentials $credentials
     *
     * @return $this
     */
    public function setCredentials(Credentials $credentials)
    {
        $this->credentials = $credentials;

        return $this;
    }

    /**
     * @return Credentials
     */
    public function getCredentials()
    {
        return $this->credentials;
    }

    /**
     * @param UserService $userService
     *
     * @return $this
     */
    public function setUserService(UserService $userService)
    {
        $this->userService = $userService;

        return $this;
    }

    /**
     * @return UserService
     */
    public function getUserService()
    {
        return $this->userService;
    }
}
