<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version2\User\Update;

use JMS\Serializer\Annotation as Serializer;

/**
 * @Serializer\XmlRoot("Key")
 *
 * Class Key
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version2\User\Update
 */
class Key
{
    /**
     * @Serializer\SerializedName("UserType")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version2\User\Update\UserKeyType")
     *
     * @var UserKeyType
     */
    protected $userKeyType;

    /**
     * @return UserKeyType
     */
    public function getUserKeyType()
    {
        return $this->userKeyType;
    }

    /**
     * @param UserKeyType $userKeyType
     * @return Key
     */
    public function setUserKeyType($userKeyType)
    {
        $this->userKeyType = $userKeyType;
        return $this;
    }
}
