<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version2\User\Update;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Update
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version2\User\Update
 */
class Update
{
    /**
     * @Serializer\SerializedName("Key")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version2\User\Update\Key")
     *
     * @var Key
     */
    protected $key;

    /**
     * @Serializer\SerializedName("Value")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Request\UserWs\Version2\User\Update\Value")
     *
     * @var Value
     */
    protected $value;

    /**
     * @return Value
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @param Value $value
     * @return Update
     */
    public function setValue(Value $value)
    {
        $this->value = $value;

        return $this;
    }

    /**
     * @return Key
     */
    public function getKey()
    {
        return $this->key;
    }

    /**
     * @param Key $key
     * @return Update
     */
    public function setKey($key)
    {
        $this->key = $key;
        return $this;
    }
}
