<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version2\User\Update;

use Sso\RestBundle\ModelXml\Common\Request\UserWs\UserTypeFields;
use JMS\Serializer\Annotation as Serializer;

/**
 * @Serializer\XmlRoot("UserType")
 * @Serializer\AccessorOrder("custom", custom = {"email", "username", "firstName", "lastName", "password", "active", "authId", "ldapSearchAttributes", "ldapSearchValue", "mfaEnabled"})
 *
 * Class UserType
 * @package Sso\RestBundle\ModelXml\Request\UserWs\Version2\User\Update
 */
class UserType
{
    use UserTypeFields;

    /**
     * @Serializer\SerializedName("MfaEnabled")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    protected $mfaEnabled;

    /**
     * @Serializer\SerializedName("MfaRecreate")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    protected $mfaRecreate;

    /**
     * @return integer
     */
    public function getMfaRecreate()
    {
        return $this->mfaRecreate;
    }

    /**
     * @param integer $mfaEnabled
     * @return UserType
     */
    public function setMfaRecreate($mfaRecreate)
    {
        $this->mfaRecreate = $mfaRecreate;
        return $this;
    }

    /**
     * @return int
     */
    public function getMfaEnabled()
    {
        return $this->mfaEnabled;
    }

    /**
     * @param int $mfaEnabled
     * @return UserType
     */
    public function setMfaEnabled($mfaEnabled)
    {
        $this->mfaEnabled = $mfaEnabled;
        return $this;
    }
}
