<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserApplication\Show;

use Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs;

/**
 * Class Factory
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserApplication\Show
 */
class Factory
{
    /**
     * @var array
     */
    private $facSetter;

    /**
     * @return Request
     */
    public function request()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Request();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return UserWs\Credentials
     */
    public function credentials()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new UserWs\Credentials();
        }
        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return UserApplication
     */
    public function userApplication()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new UserApplication();
        }
        return $this->facSetter[__FUNCTION__];
    }
}
