<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserApplication\Show;

use Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs\Credentials;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Request
 *
 * @Serializer\XmlRoot("SsoRequest")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package     Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserApplication\Show
 */
class Request
{
    /**
     * @Serializer\SerializedName("Credentials")
     * @Serializer\Type("Sso\RestBundle\ModelXml\Common\Request\Credentials\UserWs\Credentials")
     * @var Credentials
     */
    private $credentials;

    /**
     * @Serializer\SerializedName("UserApplication")
     * @Serializer\Type(" Sso\RestBundle\ModelXml\Request\UserWs\Version2\UserApplication\Show\UserApplication")
     * @var UserApplication
     */
    private $userApplication;

    /**
     * @param Credentials $credentials
     */
    public function setCredentials(Credentials $credentials)
    {
        $this->credentials = $credentials;
    }

    /**
     * @return Credentials
     */
    public function getCredentials()
    {
        return $this->credentials;
    }

    /**
     * @param UserApplication $userApplication
     */
    public function setUserApplication(UserApplication $userApplication)
    {
        $this->userApplication = $userApplication;
    }

    /**
     * @return UserApplication
     */
    public function getUserApplication()
    {
        return $this->userApplication;
    }
}
